/*
 * 
 */
package w83a.w83aDAO;



import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83a.Thread.W83ANotificacionThread;
import w83a.util.jdbc.W83aDataBase;
import w83a.w83aBeans.W83AUsuarioBean;
import w83a.w83aBeans.W83aDocumentoBean;
import w83a.w83aBeans.W83aLotesPreavisosBean;
import w83a.w83aBeans.W83aNotificacionesBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aDAO.w83aConstantesBD.W83aLotesPreavisosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aUsuariosBD;
import w83a.w83aManager.W83aComunes;
import w83a.w83aManager.W83aIComunes;
import w83a.w83aUtilidadesComunes.W83AInformacionProcedimiento;
import w83a.w83aUtilidadesComunes.W83AProperties;
import w83a.w83aUtilidadesComunes.W83AStringUtil;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aClsTrazas;
import w83a.w83aUtilidadesComunes.W83aDateUtil;
import w83a.w83aUtilidadesComunes.W83aUtilidades;
import w83a.w83aUtilidadesLibroRegistro.W83aLibroRegistro;



// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIPreavisosDAO.
 * @author a
 */
public class W83aLotesPreavisosDAO implements W83aILotesPreavisosDAO{
	
	public java.util.List buscarLotesPreavisos(W83aLotesPreavisosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)param.getUsuarioBean();
		
		strSql.append("SELECT ");
		strSql.append(W83aLotesPreavisosBD.codLote).append(",");
		strSql.append(W83aLotesPreavisosBD.nombreFichero).append(",");
		strSql.append(W83aLotesPreavisosBD.nombreFicheroVuelta).append(",");
		strSql.append(W83aLotesPreavisosBD.provinciasTable).append(".").append(W83aLotesPreavisosBD.territorio).append(",");
		strSql.append(W83aLotesPreavisosBD.numPreavisos).append(",");
		strSql.append(W83aLotesPreavisosBD.fechaEntrada).append(" AS F_ENTRADA_007_ORDER ").append(",");//Aadido para el order por fecha
		strSql.append("TO_CHAR(").append(W83aLotesPreavisosBD.fechaEntrada).append(",?) AS ").append(W83aLotesPreavisosBD.fechaEntrada).append(" ,");
		//strSql.append(W83aLotesPreavisosBD.tratado).append(",");
		
		
		strSql.append("(CASE WHEN (").append(W83aLotesPreavisosBD.tratado).append(" = 0) ");
		strSql.append(" THEN 'No' ELSE 'S' END ) AS ").append(W83aLotesPreavisosBD.tratado).append(",");
		
		
		
		strSql.append(W83aLotesPreavisosBD.siglasSindi19);
		
		strSql.append(" FROM ").append(W83aLotesPreavisosBD.lotesPreavisosTable);
		strSql.append(" , ").append(W83aLotesPreavisosBD.sindicatosTable);
		strSql.append(" , ").append(W83aLotesPreavisosBD.provinciasTable);
		strSql.append(" WHERE ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.codSindi07);
		strSql.append(" = ").append(W83aLotesPreavisosBD.sindicatosTable).append(".").append(W83aLotesPreavisosBD.codSindi19);
		strSql.append(" AND ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.codTerrit);
		strSql.append(" = ").append(W83aLotesPreavisosBD.provinciasTable).append(".").append(W83aLotesPreavisosBD.id);
		strSql.append(" AND ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.codTerrit);
		strSql.append(" = ").append(usuario.getCodTerritorioDelegacion());
		
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		//NOMBRE FICHERO
		if(StringUtils.isNotEmpty(param.getNombreFichero())){
			strSql.append(" AND ").append(W83aLotesPreavisosBD.nombreFichero).append(" LIKE ?");
			params.add(new StringBuffer().append("%").append(param.getNombreFichero())
					.append("%").toString());
		}
		
		//FECHA ENTRADA
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			strSql.append(" AND ").append(W83aLotesPreavisosBD.fechaEntrada).append(" >= to_date(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			strSql.append(" AND ").append(W83aLotesPreavisosBD.fechaEntrada).append(" <= to_date(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		//fin FECHA ENTRADA
		
		//SINDICATO
		if(StringUtils.isNotEmpty(param.getCodSindicato())){
			strSql.append(" AND ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.codSindi07).append(" = ?");
			params.add(param.getCodSindicato());
		}

		//TRATADO
		if(StringUtils.isNotEmpty(param.getTratado()) && !StringUtils.isNotEmpty(param.getNoTratado())){
			strSql.append(" AND ").append(W83aLotesPreavisosBD.tratado).append(" = 1 ");
		}if(!StringUtils.isNotEmpty(param.getTratado()) && StringUtils.isNotEmpty(param.getNoTratado())){
			strSql.append(" AND ").append(W83aLotesPreavisosBD.tratado).append(" = 0 ");
		}
		
		
		
		if(!param.getIdColumna().equalsIgnoreCase("")){
			
			if(param.getIdColumna().equalsIgnoreCase(W83aLotesPreavisosBD.fechaEntrada)){
				strSql.append(" ORDER BY ").append("F_ENTRADA_007_ORDER").append(" ").append(param.getSort());
			}else{
				strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());
			}
		}
		
		
		List listaLotesPreavisos = W83aDataBase.executeQuery(strSql.toString(),params,W83aLotesPreavisosBean.class,param.getUsuarioBean(), null);
		
		W83aClsTrazas.trazaError(null, "** AUDITORIA ** ACCESO A CONSULTAR LA LISTA DE LOTES POR EL USUARIO: " + usuario.getDniUsuario(), null);
		
		return listaLotesPreavisos;		
	}
	
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleArbitro(w83b.w83bBeans.W83bArbitrosBean)
	 */
	public W83aLotesPreavisosBean detalleLotesPreavisos(W83aLotesPreavisosBean param)
			throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();

		W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)param.getUsuarioBean();
		
		strSql.append("SELECT ");
		strSql.append(W83aLotesPreavisosBD.codLote).append(",");
		strSql.append(W83aLotesPreavisosBD.territorio).append(",");
		strSql.append(W83aLotesPreavisosBD.codTerrit).append(",");
		strSql.append(W83aLotesPreavisosBD.correlativo).append(",");
		if("eu".equals(param.getIdioma())){
			strSql.append(W83aLotesPreavisosBD.descSindiEus).append(" AS ").append(W83aLotesPreavisosBD.descSindi).append(",");
		}else{
			strSql.append(W83aLotesPreavisosBD.descSindi).append(" AS ").append(W83aLotesPreavisosBD.descSindi).append(",");
		}		   
		strSql.append(W83aLotesPreavisosBD.nombreFichero).append(",");
		strSql.append(W83aLotesPreavisosBD.nombreFicheroVuelta).append(",");
		strSql.append(W83aLotesPreavisosBD.ficheroIda).append(",");
		strSql.append(W83aLotesPreavisosBD.ficheroVuelta).append(",");
		strSql.append(" TO_CHAR( ").append(W83aLotesPreavisosBD.fechaCreacion).append(",?) AS ").append(W83aLotesPreavisosBD.fechaCreacion).append(",");
		strSql.append(" TO_CHAR( ").append(W83aLotesPreavisosBD.fechaEntrada).append(",?) AS ").append(W83aLotesPreavisosBD.fechaEntrada);
		
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		strSql.append(" FROM ").append(W83aLotesPreavisosBD.lotesPreavisosTable);
		strSql.append(" , ").append(W83aLotesPreavisosBD.sindicatosTable);
		strSql.append(" , ").append(W83aLotesPreavisosBD.provinciasTable);
		strSql.append(" WHERE ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.codTerrit);
		strSql.append(" = ").append(W83aLotesPreavisosBD.provinciasTable).append(".").append(W83aLotesPreavisosBD.id);
		strSql.append(" AND ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.codSindi07);
		strSql.append(" = ").append(W83aLotesPreavisosBD.sindicatosTable).append(".").append(W83aLotesPreavisosBD.codSindi19);
		strSql.append(" AND ").append(W83aLotesPreavisosBD.codLote).append(" = ? ");
		params.add(param.getCodLote());

		W83aClsTrazas.trazaError(null, "SQL:"+ strSql.toString(),new Exception());//NOPMD
		W83aClsTrazas.trazaError(null, "LOTE: " + param.getCodLote(),new Exception());//NOPMD
		
		List listaLotes = W83aDataBase.executeQuery(strSql.toString(),params,W83aLotesPreavisosBean.class,param.getUsuarioBean(), null);
	
		W83aLotesPreavisosBean resultado = (W83aLotesPreavisosBean)listaLotes.get(0);
		
		W83aClsTrazas.trazaError(null, "** AUDITORIA ** CONSULTA DEL LOTE: "+ resultado.getNombreFichero() +" POR EL USUARIO: " +usuario.getDniUsuario(), null);
		
		
		return resultado;	
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleArbitro(w83b.w83bBeans.W83bArbitrosBean)
	 */
	public List detallePreavisos(W83aLotesPreavisosBean param)
	throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
	

		
		strSql.append("SELECT ");
		strSql.append(W83aLotesPreavisosBD.id8).append(",");
		strSql.append(W83aLotesPreavisosBD.cif).append(",");
		strSql.append(W83aLotesPreavisosBD.razonSocial).append(",");
		strSql.append("DECODE(").append(W83aLotesPreavisosBD.territorio).append(", '', 'No existe', ").append(W83aLotesPreavisosBD.territorio).append(") AS ").append(W83aLotesPreavisosBD.municipio8).append(",");
		strSql.append("DECODE(").append(W83aLotesPreavisosBD.siglasSindi19).append(", '', 'No existe', ").append(W83aLotesPreavisosBD.siglasSindi19).append(") AS ").append(W83aLotesPreavisosBD.siglasSindi19).append(",");
		strSql.append(W83aLotesPreavisosBD.centrosAfect).append(",");
	    strSql.append(" TO_CHAR( ").append(W83aLotesPreavisosBD.fechaInicio).append(",?) AS ").append(W83aLotesPreavisosBD.fechaInicio);
		
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(",").append(W83aLotesPreavisosBD.estado8);
		strSql.append(" FROM ").append(W83aLotesPreavisosBD.preavisosTable);
		strSql.append(" , ").append(W83aLotesPreavisosBD.lotesPreavisosTable);
		strSql.append(" , ").append(W83aLotesPreavisosBD.sindicatosTable);
		strSql.append(" , ").append(W83aLotesPreavisosBD.municipiosTable);
		strSql.append(" WHERE ").append(W83aLotesPreavisosBD.codLote8);
		strSql.append(" = ").append(W83aLotesPreavisosBD.codLote);
		strSql.append(" AND ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.codSindi07);
		strSql.append(" = ").append(W83aLotesPreavisosBD.sindicatosTable).append(".").append(W83aLotesPreavisosBD.codSindi19).append("(+)");
		strSql.append(" AND ").append(W83aLotesPreavisosBD.codLote8).append(" = ? ");

		params.add(param.getCodLote());

		strSql.append(" AND ").append(W83aLotesPreavisosBD.provincia).append("(+) = ").append(W83aLotesPreavisosBD.territorio8);
		strSql.append(" AND ").append(W83aLotesPreavisosBD.id).append("(+) = ").append(W83aLotesPreavisosBD.municipio8);
		if("1".equals(param.getColumna())){
			strSql.append(" AND ").append(W83aLotesPreavisosBD.tipo8).append(" ='I' ");
		}else if("2".equals(param.getColumna())){
			strSql.append(" AND ").append(W83aLotesPreavisosBD.tipo8).append(" ='V' ");
		}
		if(!param.getIdColumna().equalsIgnoreCase("")){
			strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());
		}else{
			strSql.append(" ORDER BY ").append(W83aLotesPreavisosBD.id8);
		}
		
		
		List listaPreavisos = W83aDataBase.executeQuery(strSql.toString(),params,W83aLotesPreavisosBean.class,param.getUsuarioBean(), null);
		W83aLotesPreavisosBean bean = new W83aLotesPreavisosBean();
		for(int i=0;i<listaPreavisos.size();i++){
			bean = (W83aLotesPreavisosBean)listaPreavisos.get(i);
			bean.setId8(i+"_"+bean.getId8());
			W83aClsTrazas.trazaError(null, "bean.getId8()"+bean.getId8(),new Exception());//NOPMD
		}
		
		
		return listaPreavisos;	
		

	
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleArbitro(w83b.w83bBeans.W83bArbitrosBean)
	 */
	public W83aLotesPreavisosBean obtenerDetallePreaviso(W83aLotesPreavisosBean param)
	throws Exception {
		
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aLotesPreavisosBD.id8).append(",");
		strSql.append(W83aLotesPreavisosBD.cif).append(",");
		strSql.append(W83aLotesPreavisosBD.razonSocial).append(",");
		strSql.append(W83aLotesPreavisosBD.domicilio).append(" , ");
		strSql.append(W83aLotesPreavisosBD.territorio8).append(",");
		strSql.append(W83aLotesPreavisosBD.municipio8).append(",");
		strSql.append(W83aLotesPreavisosBD.codPostal8).append(",");
		strSql.append(W83aLotesPreavisosBD.telefono8).append(",");
		strSql.append(W83aLotesPreavisosBD.fax8).append(",");
		strSql.append(W83aLotesPreavisosBD.email8).append(",");
		strSql.append(W83aLotesPreavisosBD.cnae8).append(",");
		strSql.append(" TO_CHAR( ").append(W83aLotesPreavisosBD.fechaInicio).append(",?) AS ").append(W83aLotesPreavisosBD.fechaInicio).append(",");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83aLotesPreavisosBD.codConvenio8).append(",");
		strSql.append(W83aLotesPreavisosBD.parcial8).append(",");
		strSql.append(W83aLotesPreavisosBD.global8).append(",");
		strSql.append(W83aLotesPreavisosBD.admonEmp8).append(",");
		strSql.append(W83aLotesPreavisosBD.centrosAfect).append(",");
		strSql.append(W83aLotesPreavisosBD.codSindi8).append(",");
		strSql.append(W83aLotesPreavisosBD.codSindiMulti8).append(",");
		strSql.append(W83aLotesPreavisosBD.numReg8).append(",");
		strSql.append(" TO_CHAR( ").append(W83aLotesPreavisosBD.fechaReg8).append(",?) AS ").append(W83aLotesPreavisosBD.fechaReg8).append(",");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83aLotesPreavisosBD.preaviso8).append(",");
		strSql.append(W83aLotesPreavisosBD.anyopreaviso8).append(",");
		strSql.append(W83aLotesPreavisosBD.numTrab8).append(",");
		strSql.append(W83aLotesPreavisosBD.thSS8).append(",");
		strSql.append(W83aLotesPreavisosBD.numSS8).append(",");
		strSql.append(W83aLotesPreavisosBD.ctrlSS8).append(",");
		strSql.append(W83aLotesPreavisosBD.ident8).append(",");
		strSql.append(W83aLotesPreavisosBD.observaciones8);
		
		
		
		
		strSql.append(" FROM ").append(W83aLotesPreavisosBD.preavisosTable);
		
		strSql.append(" WHERE ").append(W83aLotesPreavisosBD.id8).append(" = ? ");
		
		try{
			params.add(param.getId8().split("_")[1]);
		}catch(Exception e){
			params.add(param.getId8());
		}
		
		if(!param.getIdColumna().equalsIgnoreCase("")){
			strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());
		}
		
		
		List listaPreavisos = W83aDataBase.executeQuery(strSql.toString(),params,W83aLotesPreavisosBean.class,param.getUsuarioBean(), null);
		
		return (W83aLotesPreavisosBean)listaPreavisos.get(0);	
		
	}
	
	
	public HashMap anyadirLotePreavisos(W83aLotesPreavisosBean param) throws Exception {
		
		W83aClsTrazas.trazaDebug(null, "anyadirLotePreavisos entrando!");
		
		
		 
		W83aDocumentoBean doc = new W83aDocumentoBean();
		if(param.getListaDocs().size()>0){
			doc=(W83aDocumentoBean)param.getListaDocs().get(0);
		}
		
		W83aClsTrazas.trazaError(null, " doc: " + doc.getNombre(),new Exception());//NOPMD
		
		List existe = new ArrayList();
		
		if(param.getListaDocs().size()>0){
			//miro a ver si ya existe el fichero
			StringBuffer strSqlExiste = new StringBuffer();
			strSqlExiste.append("SELECT ");
			strSqlExiste.append(W83aLotesPreavisosBD.codLote).append(",");
			strSqlExiste.append(W83aLotesPreavisosBD.firmado);
			strSqlExiste.append(" FROM ");
			strSqlExiste.append(W83aLotesPreavisosBD.lotesPreavisosTable);
			strSqlExiste.append(" WHERE ");
			strSqlExiste.append(W83aLotesPreavisosBD.nombreFichero).append(" ='").append(doc.getNombre()).append("'");
			existe = W83aDataBase.executeQuery(strSqlExiste.toString(),new ArrayList(),W83aLotesPreavisosBean.class,param.getUsuarioBean(), "CONSULTAFIRMADO");
			W83aClsTrazas.trazaDebug(null, "EXISTE LOTE "+((existe.size()>0)?"si":"no"));
		}	
		
		HashMap mapa = new HashMap();
		if(param.getListaDocs().size()==0){
			//Fichero de lote vaco! se muestra mensaje de error
			mapa.put("error", "ficherovacio");
			return mapa;
		}else if(existe.size()>0){
			
			W83aLotesPreavisosBean loteExistente = (W83aLotesPreavisosBean)existe.get(0);
			W83aClsTrazas.trazaDebug(null, "loteExistente es el "+loteExistente.getCodLote());
			W83aClsTrazas.trazaDebug(null, "loteExistente firmado "+loteExistente.getFirmado());
			
			//Comprobamos si esta firmado 
			if(W83aClsConstantes.LOTE_FIRMADO.equals(loteExistente.getFirmado())){
				//firmado: ERROR YA EXISTE NO PUEDE VOLVER A CREARLO
				mapa.put("error", "ficheroexiste");
				return mapa;
			}else{
				//No firmado: eliminamos los datos del existente
				this.deshacerAltaLote(loteExistente);
			}
		}
		
		//miro a ver cual es el ultimo id usado (LOTE_007)
		StringBuffer strSqlCorrelativo = new StringBuffer();
		strSqlCorrelativo.append("SELECT MAX(");
		strSqlCorrelativo.append(W83aLotesPreavisosBD.codLote);
		strSqlCorrelativo.append(") AS ").append(W83aLotesPreavisosBD.codLote);;
		strSqlCorrelativo.append(" FROM ");
		strSqlCorrelativo.append(W83aLotesPreavisosBD.lotesPreavisosTable);
		
		List idLote = W83aDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
		int idLoteNext=1;
		
		if (idLote!=null && idLote.size()>0 && idLote.get(0)!=null)
		{
			idLoteNext=Integer.parseInt(idLote.get(0).toString())+1;
		}
		//cojo el dni del usuario logueado
		W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)doc.getUsuario();
		String dni = usuario.getDniUsuario();
		
		if (dni.length()==8){
			if (dni.substring(0,1).matches("[0-9]")){
				dni=W83aUtilidades.letraDNI(dni);
			}
			else{
				dni=W83aUtilidades.letraNIE(dni);
			}
		}
		
		param.setIdioma(usuario.getIdioma());
		//cojo la fecha del sistema
		String formato=W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma());
		SimpleDateFormat sdf =new SimpleDateFormat(formato);
		
		String fechaEntrada =sdf.format(new Date());
		
		//nombre del fichero
		String nombreFichero = doc.getNombre();
		
	
		//Fin Libro Registro
		
		//y ahora voy leyendo el archivo para obtener los datos
	    
	    InputStream inputstream = doc.getFileData();
	        

	    int read = 0;
	    byte[] bytes = new byte[1024*1024*2];

	    ByteArrayOutputStream bos = new ByteArrayOutputStream();
	    while ((read = inputstream.read(bytes)) != -1)
	        bos.write(bytes,0,read);
	    byte[] ba = bos.toByteArray();

	    InputStream is1 = new ByteArrayInputStream(ba);
	    InputStream is2 = new ByteArrayInputStream(ba);
	    InputStream is3 = new ByteArrayInputStream(ba);
	    

		
		
		BufferedReader br = new BufferedReader(new InputStreamReader(is2, "UTF-8"));
		
	    String linea="";
	    String codSindicato="";
	    String codTerritorio="";
	    String fechaCreacion="";
	    String correlativo="";
	    String numPreavisos="";
	    String numCentrosAfectados="";
	    String numTotalTrab="";
	    boolean bienFormado1 = false;
	    boolean bienFormado2 = true;
	    boolean bienFormado3 = false;
	    boolean bienFormado4 = true;
	    boolean anteriorLinea2 = false;//Boolean para comprobar que una linea tipo 4 viene despues de una tipo 2
	    boolean siguienteLinea4 = false;
	    while((linea=br.readLine())!=null){
	      	 
	      	 //tipo de linea 1
	      	 if("1".equals(linea.substring(0,1))){
	      		 if(linea.length()==17 && !siguienteLinea4){
		      		 codTerritorio = linea.substring(1,3);
		      		 codSindicato = linea.substring(3,6);
		      		 correlativo = linea.substring(6,9);
		      		 if(linea.length()>9){
		      			fechaCreacion = linea.substring(9, linea.length()); 
		      		 }
		      		bienFormado1 = true;
	      		 }
	      		anteriorLinea2 = false;
	      		siguienteLinea4 = false;
	      	 }
	      	 //tipo de linea 2
	      	 else if("2".equals(linea.substring(0,1))){
	      		if(linea.length()!=585 || siguienteLinea4){
	      			bienFormado2 = false;
	      		}else{
	      			if(linea.substring(242,245).equals(W83aClsConstantes.VARIOS_SINDICATOS_PROMOTORES)){
		      			 //La siguiente linea debe ser 4 ya que se ha indicado que son varios promotores
	      				siguienteLinea4 = true;
		      		 }else{
		      			siguienteLinea4 = false;
		      		 }
	      		}
	      		anteriorLinea2 = true;
	      	 }
	      	 //tipo de linea 3
	      	 else if("3".equals(linea.substring(0,1))){
	      		if(linea.length()==22 && !siguienteLinea4){
		      		 numPreavisos = linea.substring(1,4);
		      		 numCentrosAfectados = linea.substring(4,13);
		      		 numTotalTrab = linea.substring(13,22);
		      		 bienFormado3 = true;
	      		}
	      		anteriorLinea2 = false;
	      		siguienteLinea4 = false;
	      		//tipo de linea 4
	      	 } else if("4".equals(linea.substring(0,1))){
	      		if(linea.length()<7 || linea.length()>25 || linea.length()%3!=1 ||  !anteriorLinea2 || !siguienteLinea4){
	      			bienFormado4 = false;
	      		}
	      		anteriorLinea2 = false;
	      		siguienteLinea4 = false;
	      	 }
	       	
	    }
	    

	    if(bienFormado1 && bienFormado2 && bienFormado3 && bienFormado4){
			StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
			List params = new ArrayList();
	    	strSql.append("INSERT INTO ");
			strSql.append(W83aLotesPreavisosBD.lotesPreavisosTable);
			strSql.append("(");
			strSql.append(W83aLotesPreavisosBD.codLote).append(",");
			
			strSql.append(W83aLotesPreavisosBD.nombreFichero).append(",");
			strSql.append(W83aLotesPreavisosBD.ficheroIda).append(",");
			strSql.append(W83aLotesPreavisosBD.firmado).append(")");

		
			strSql.append(" VALUES (?,?,?,?)");
	
	
			params.add(new Integer(idLoteNext));
			params.add(nombreFichero);
			params.add(is1);
			params.add(W83aClsConstantes.LOTE_NO_FIRMADO);

			
	
			W83aDataBase.executeBlobTableMovement(strSql.toString(), params,doc.getTamanyo(),doc.getUsuario());
			
		    params.clear();
		    strSql = new StringBuffer();
			strSql.append("UPDATE ") ;
			strSql.append(W83aLotesPreavisosBD.lotesPreavisosTable);
			strSql.append(" SET ");
			strSql.append(W83aLotesPreavisosBD.dni);
			strSql.append(" = ?");
			strSql.append(",");
			strSql.append(W83aLotesPreavisosBD.codSindi07);
			strSql.append(" = ?");
			strSql.append(",");
			strSql.append(W83aLotesPreavisosBD.fechaEntrada);
			if(StringUtils.isNotEmpty(fechaCreacion)){
				strSql.append("=to_date(?,?)");
			}else{
				strSql.append("=?");			
			}
			strSql.append(",");
			strSql.append(W83aLotesPreavisosBD.codTerrit);
			strSql.append(" = ?");
			strSql.append(",");
			strSql.append(W83aLotesPreavisosBD.fechaCreacion);
			strSql.append(" = to_date(?,?)");
			strSql.append(",");
			strSql.append(W83aLotesPreavisosBD.correlativo);
			strSql.append(" = ?");
			strSql.append(",");
			strSql.append(W83aLotesPreavisosBD.numPreavisos);
			strSql.append(" = ?");
			strSql.append(",");
			strSql.append(W83aLotesPreavisosBD.centrosAfect7);
			strSql.append(" = ?").append(",");
			strSql.append(W83aLotesPreavisosBD.numTrab7);
			strSql.append(" = ?");
			strSql.append(" WHERE ").append(W83aLotesPreavisosBD.codLote).append(" = ? ");
			
			
			params.add(dni);
			params.add(codSindicato);
			params.add(fechaEntrada);
			params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(codTerritorio);
			if(StringUtils.isNotEmpty(fechaCreacion)){
				params.add(fechaCreacion);
				 params.add(W83aDateUtil.getInstance().devolverFormatoIdioma("eu"));
			}else{
				params.add(W83aClsConstantes.NULL_DATE);
			}
			
			params.add(correlativo);
	
			params.add(numPreavisos);
			params.add(numCentrosAfectados);
			params.add(numTotalTrab);
			params.add(new Integer(idLoteNext));
			
			W83aDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
			
			strSqlCorrelativo = new StringBuffer();
			strSqlCorrelativo.append("SELECT MAX(");
			strSqlCorrelativo.append(W83aLotesPreavisosBD.idPreaviso8);
			strSqlCorrelativo.append(") AS ").append(W83aLotesPreavisosBD.idPreaviso8);;
			strSqlCorrelativo.append(" FROM ");
			strSqlCorrelativo.append(W83aLotesPreavisosBD.preavisosTable);
			
			
			
			List idPreaviso = W83aDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
			int idPreavNext=1;
			
			if (idPreaviso!=null && idPreaviso.size()>0 && idPreaviso.get(0)!=null)
			{
				idPreavNext=Integer.parseInt(idPreaviso.get(0).toString())+1;
			}
		        
		    
			
		    BufferedReader br2 = new BufferedReader(new InputStreamReader(is3, "ISO-8859-1"));
		    String linea2="";
		    
		    String cif="";
		    String razonSocial=""; 
		    String domicilio=""; 
		    String municipio=""; 
		    String codPostal=""; 
		    String telefono=""; 
		    String email=""; 
		    String fax=""; 
		    String cnae=""; 
		    String fInicio=""; 
		    String codConvenio=""; 
		    String parcial=""; 
		    String global=""; 
		    String centrosAfectados=""; 
		    String admonEmpresa=""; 
		    
		    String ident=""; 
		    String codSindi=""; 
		    String observaciones=""; 
		    
		    String tipoIden="";
		    String territorioSS="";
		    String numSS="";
		    String ctrlSS="";
		    String numTrabaj="";
		    String provinciaPreaviso="";
		    
		    //Campos registro promotores
		    boolean necesitaPromotores = false;
		    
		    
		    
		    while((linea2=br2.readLine())!=null){
		      
		      	 if("2".equals(linea2.substring(0,1))){
		      		 
		      		 //si esta marcado  "necesitaPromotores" como true es que no se ha aadido la fila de promotores a pesar de indicar que es true
		      		 if(necesitaPromotores){
		      			throw new Exception("Fichero de lote de preavisos mal formado: No se ha aadido la fila de promotores");
		      		 }
		      		 
		      		 cif = linea2.substring(1,10);
		      		 tipoIden = linea2.substring(10,11);
		      		 razonSocial = linea2.substring(11,61);
		      		 domicilio = linea2.substring(61,111);
		      		 provinciaPreaviso = linea2.substring(111,113);
		      		 municipio = linea2.substring(113,116);
		      		 municipio = municipio.trim();
		      		 if(municipio.length()<3){
		      			municipio = W83AStringUtil.toStringNumerico(municipio, 3);
		      		 }
		      		 codPostal = linea2.substring(116,121);
		      		 telefono = linea2.substring(121,136);
		      		 fax = linea2.substring(136,151);
		      		 email = linea2.substring(151,201);
		      		 cnae = linea2.substring(201,205);
		      		 cnae = cnae.trim();
		      		 if(cnae.length()<4){
		      			cnae = W83AStringUtil.toStringNumerico(cnae, 4);
		      		 }
		      		 territorioSS = linea2.substring(205, 207);
		      		 numSS = linea2.substring(207,214);
		      		 ctrlSS = linea2.substring(214, 216);
		      		 numTrabaj = linea2.substring(235, 241);
		      	 	 fInicio = linea2.substring(216, 224);
		      		 codConvenio = linea2.substring(224, 227);
		      		 parcial = linea2.substring(227,228);
		      		 global = linea2.substring(228,229);
		      		 centrosAfectados = linea2.substring(229, 235);
		      		 admonEmpresa = linea2.substring(241,242);
		      		 codSindi = linea2.substring(242,245);
		      		 
		      		 if(codSindi.equals(W83aClsConstantes.VARIOS_SINDICATOS_PROMOTORES)){
		      			 //comprobamos si lleva varios sindicatos (cod sindicato 999 y indicados en la siguiente linea) o es uno slo
		      			necesitaPromotores = true;
		      		 }
		      		 
		      		 // TODO falta los datos del gobierno
		      		 
		      		 ident = linea2.substring(280, 330);
		      		 observaciones = linea2.substring(330,585);
		      		 
		      		 params.clear();
		      		 strSql = new StringBuffer(W83aClsConstantes.CUARENTA);//NOPMD
		      		 strSql.append("INSERT INTO ");
		     		 strSql.append(W83aLotesPreavisosBD.preavisosTable);
		     		 strSql.append("(");
		     		 strSql.append(W83aLotesPreavisosBD.idPreaviso8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.cif).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.razonSocial).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.domicilio).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.territorio8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.municipio8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.fechaInicio).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.centrosAfect).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.codLote8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.codPostal8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.telefono8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.fax8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.email8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.cnae8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.codConvenio8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.parcial8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.global8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.admonEmp8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.codSindi8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.ident8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.tipoIden8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.provincia8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.thSS8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.numSS8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.ctrlSS8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.numTrab8).append(",");
		     		 strSql.append(W83aLotesPreavisosBD.observaciones8).append(")");
		     		 
		     		 
		     		 strSql.append(" VALUES (?,?,?,?,?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
	 				
		     		 params.add(new Integer(idPreavNext));//NOPMD
		     		 params.add(cif);
		     		 params.add(razonSocial);
		     		 params.add(domicilio);
		     		 params.add(codTerritorio);
		     		 params.add(municipio);
		     		 params.add(fInicio);
	    			 params.add(W83aDateUtil.getInstance().devolverFormatoIdioma("eu"));
	    			 params.add(centrosAfectados);
	    			 params.add(new Integer(idLoteNext));//NOPMD
	    			 params.add(codPostal);
	    			 params.add(telefono);
	    			 params.add(fax);
	    			 params.add(email);
	    			 params.add(cnae);
	    			 params.add(codConvenio);
	    			 params.add(parcial);
	    			 params.add(global);
	    			 params.add(admonEmpresa);
	    			 params.add(codSindi);
	    			 params.add(ident);
	    			 params.add(tipoIden);
	    			 params.add(provinciaPreaviso);
	    			 params.add(territorioSS);
	    			 params.add(numSS);
	    			 params.add(ctrlSS);
	    			 params.add(numTrabaj);
	    			 params.add(observaciones);
		     		
	    			 W83aDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
	    			  
	    			  idPreavNext=idPreavNext+1;
		      	 }else if("4".equals(linea2.substring(0,1)) ){ 
		      		
		      		 //Comprobamos que la lnea anterior haya marcado necesita promotor como true
		      		 if(!necesitaPromotores){
		      			 throw new Exception("Fichero de lote de preavisos mal formado: Se ha aadido fila promotores sin necesitar");
		      		 }
		      		 
		      		 
		      		 
		      		 //Actualizamos el campo de promotores del preaviso
		      		 params.clear();
		      		 strSql = new StringBuffer(W83aClsConstantes.CUARENTA);//NOPMD
		      		 strSql.append("UPDATE ").append(W83aLotesPreavisosBD.preavisosTable).append(" SET ");
		     		 strSql.append(W83aLotesPreavisosBD.codSindiMulti8);
		     		 strSql.append(" =  ? WHERE ").append(W83aLotesPreavisosBD.idPreaviso8).append(" = ?");
		     		 
		     		 params.add(linea2.substring(1,linea2.length()));
		     		 params.add(String.valueOf(idPreavNext-1));
		      		 
		     		 W83aDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		     		 
		      		 necesitaPromotores = false;
		      	 }
		    }
		    mapa.put("codSelec",idLoteNext+"");
	    	mapa.put("error", "sinerror");
	    } else{
	    	mapa.put("error", "malformado");
	    }
	    
	   
	    
		return mapa;
	}
	
	public W83aLotesPreavisosBean firmarDocumento(W83aLotesPreavisosBean param)
	throws Exception {
		
		W83aClsTrazas.trazaDebug(null, "@@@@@@@@@@@firmarDocumento @@@@@@@@@@@@");
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)param.getUsuarioBean();
		//String dni = usuario.getDniUsuario();
		param.setIdioma(usuario.getIdioma());
		
		W83aClsTrazas.trazaDebug(null, "@@@@@@@@@@@firmarDocumento 2@@@@@@@@@@@@");
		
		W83aUsuarioXLNetsBean usuarioLimitado = ((W83aIComunes)(W83aComunes.class.newInstance())).refrescarUsuarioDelegacion(usuario);
		 
		usuario.setModelo(usuarioLimitado.getModelo());
		usuario.setModeloSal(usuarioLimitado.getModeloSal());
		
		W83aClsTrazas.trazaDebug(null, "@@@@@@@@@@@firmarDocumento 3@@@@@@@@@@@@");
		//String empresa=param.getCodPromotor();
		W83aClsTrazas.trazaDebug(null,"param.getCodPromotor()="+param.getCodPromotor());
		W83aClsTrazas.trazaDebug(null,"param.getCodsPromotorMulti="+param.getCodsPromotorMulti());
		W83aClsTrazas.trazaDebug(null,"param.getSindicato()="+param.getSindicato());
		W83aClsTrazas.trazaDebug(null,"usuario.getCodTerritorioDelegacion()="+usuario.getCodTerritorioDelegacion());
		
		W83aClsTrazas.trazaDebug(null, "@@@@@@@@@@@firmarDocumento 4@@@@@@@@@@@@");
		String sesionToken = W83ANotificacionThread.getTokenXLNets("w83a");
		
		W83aClsTrazas.trazaDebug(null, "@@@@@@@@@@@firmarDocumento 5@@@@@@@@@@@@");
		String [] resul = W83aLibroRegistro.crearEntradaRegistro(sesionToken, usuario);
		//String [] resul=W83aLibroRegistro.getAltaRegistro(true, usuario.getModelo(), "E", "E", param.getSindicato(), usuario.getCodTerritorioDelegacion(), "", "", usuario);
		//String [] resul=W83aLibroRegistro.getAltaRegistro(true, usuario.getModelo(), "E", "E", empresa, param.getCodTerritorio(), "", "", usuario);
				
		param.setFechaRegES(resul[1]);
		param.setNumRegES(resul[0]); 
		
		String contenidoFirma = param.getFirma();

		InputStream is = new ByteArrayInputStream(contenidoFirma.getBytes());
		byte[] b = contenidoFirma.getBytes();
	    
		
		strSql.append("UPDATE ") ;
		strSql.append(W83aLotesPreavisosBD.lotesPreavisosTable);
		strSql.append(" SET ");
		strSql.append(W83aLotesPreavisosBD.fechaReg7);
		strSql.append(" = to_date(?,?)");
		strSql.append(",");
		strSql.append(W83aLotesPreavisosBD.numReg7);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83aLotesPreavisosBD.firmado);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83aLotesPreavisosBD.firma);
		strSql.append(" =?");
		strSql.append(" WHERE ").append(W83aLotesPreavisosBD.nombreFichero).append(" = ? ");
		

		params.add(param.getFechaRegES());
		if(param.getFechaRegES().length()>10){
			params.add(W83aDateUtil.getInstance().devolverFormatoHoraVeinticuatroAlternativaIdioma("es"));
		}else{
			params.add(W83aDateUtil.getInstance().devolverFormatoIdioma("es"));					
		}
		 params.add(param.getNumRegES());
		 params.add(W83aClsConstantes.LOTE_FIRMADO);
		 params.add(is);
		 params.add(param.getNombreFichero());
		 
		 
		 W83aClsTrazas.trazaError(null, " DAOOOO firmarDocumento:: " + strSql.toString(),null);
		 W83aClsTrazas.trazaError(null, " DAOOOO params:: " + params,null);
		 
		//W83aDataBase.executeTableMovement(strSql.toString(), params,usuario);
		 W83aDataBase.executeBlobTableMovement(strSql.toString(), params,b.length,usuario);
		
		 strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		 params = new ArrayList();
		 strSql.append("UPDATE ") ;
			strSql.append(W83aLotesPreavisosBD.preavisosTable);
			strSql.append(" SET ");
			strSql.append(W83aLotesPreavisosBD.fechaReg8);
			strSql.append(" = to_date(?,?)");
			strSql.append(",");
			strSql.append(W83aLotesPreavisosBD.numReg8);
			strSql.append(" = ?");
			
			strSql.append(" WHERE ").append(W83aLotesPreavisosBD.codLote8).append(" = ? ");
			

			 params.add(param.getFechaRegES());
			 if(param.getFechaRegES().length()>10){
					params.add(W83aDateUtil.getInstance().devolverFormatoHoraVeinticuatroAlternativaIdioma("es"));
				}else{
					params.add(W83aDateUtil.getInstance().devolverFormatoIdioma("es"));					
				}
			 params.add(param.getNumRegES());
			
			 params.add(param.getCodLote());
			 
			 
			 W83aClsTrazas.trazaError(null, " DAOOOO firmarDocumento222:: " + strSql.toString(),null);
			 W83aClsTrazas.trazaError(null, " DAOOOO params222:: " + params,null);
			W83aDataBase.executeTableMovement(strSql.toString(), params,usuario);
			 //W83aDataBase.executeBlobTableMovement(strSql.toString(), params,b.length,usuario);
			 
		return param ;	
		
	}
	
	public W83aLotesPreavisosBean generarNotificaciones(W83aLotesPreavisosBean param)
	throws Exception {
		
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		StringBuffer strSqlCorrelativo = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)param.getUsuarioBean();
		
		param.setIdioma(usuario.getIdioma());
		
		//String territorio = W83aUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());
		String territorio = usuario.getCodTerritorioDelegacion();
		
		//Obtengo los sindicatos a los que hay que notificar
		strSql.append("SELECT ");
		strSql.append(W83aUsuariosBD.dni);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.territorio);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.nombre);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.apellido1);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.apellido2);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.email);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.fechaAlta);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.fechaBaja);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.telefono);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.codSindi);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.descProvincia);
		strSql.append(", ");
		strSql.append(W83aUsuariosBD.rol);
		strSql.append(" FROM ");
		strSql.append(W83aUsuariosBD.usuariosTable);
		strSql.append(" , ").append(W83aUsuariosBD.provinciasTable);
		strSql.append(" WHERE ");
		strSql.append(W83aUsuariosBD.rol).append("=1");
		strSql.append(" AND ");
		strSql.append(W83aUsuariosBD.territorio).append("=").append(territorio);
		strSql.append(" AND ");
		strSql.append(W83aUsuariosBD.territorio).append("=").append(W83aUsuariosBD.idProvincia);
		strSql.append(" AND ");
		strSql.append(W83aUsuariosBD.fechaBaja).append(" IS NULL ");
		
		W83aClsTrazas.trazaError(null," $$$$$$$$$$$$$$$$$$$$$$ strSql::: "+strSql.toString(),new Exception());//NOPMD
		
		//List listaSindicatos = W83aDataBase.executeSimpleQuery(strSql.toString(),new ArrayList(),null);
		List listaSindicatos = W83aDataBase.executeQuery(strSql.toString(),params,W83AUsuarioBean.class,param.getUsuarioBean(), null);
		W83aClsTrazas.trazaError(null,"$$$$$$$$$$$$$$$$$$$$$$ listaSindicatos::: "+listaSindicatos.size(),new Exception());//NOPMD
		W83AUsuarioBean elSindi = new W83AUsuarioBean();
		
		for(int i=0;i<listaSindicatos.size();i++){
			elSindi = new W83AUsuarioBean();//NOPMD
			elSindi = (W83AUsuarioBean)listaSindicatos.get(i);
			
			strSql = new StringBuffer();//NOPMD
			strSql.append("SELECT ");
			strSql.append(W83aLotesPreavisosBD.siglasSindi19);
			strSql.append(" FROM ");
			strSql.append(W83aLotesPreavisosBD.sindicatosTable);
			strSql.append(" WHERE ");
			strSql.append(W83aLotesPreavisosBD.codSindi19).append("=").append(elSindi.getOrganizacion());
			List lasSiglas = W83aDataBase.executeQuery(strSql.toString(),params,W83aLotesPreavisosBean.class,param.getUsuarioBean(), null);
			W83aClsTrazas.trazaError(null,"$$$$$$$$$$$$$$$$$$$$$$ lasSiglas::: "+lasSiglas.size() ,new Exception());//NOPMD
			String descSindi ="";
			if(lasSiglas.size()>0){
				W83aLotesPreavisosBean siglas = (W83aLotesPreavisosBean)lasSiglas.get(0);
				descSindi=siglas.getSiglasSindi();
				W83aClsTrazas.trazaError(null,"$$$$$$$$$$$$$$$$$$$$$$ descSindi::: "+descSindi ,new Exception());//NOPMD
			}
			
			elSindi.setDescSindi(descSindi);
			
			
		}
		
		
		//miro a ver cua es el idLote
		strSqlCorrelativo = new StringBuffer();
		strSqlCorrelativo.append("SELECT MAX(");
		strSqlCorrelativo.append(W83aLotesPreavisosBD.codLote);
		strSqlCorrelativo.append(") AS ").append(W83aLotesPreavisosBD.codLote);;
		strSqlCorrelativo.append(" FROM ");
		strSqlCorrelativo.append(W83aLotesPreavisosBD.lotesPreavisosTable);
		
		List idPreaviso = W83aDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
		int idLoteNext=1;
		
		W83aClsTrazas.trazaError(null, " &&&&&& idPreaviso.size():"+ idPreaviso.size(),new Exception());//NOPMD
		W83aClsTrazas.trazaError(null, " &&&&&& idPreaviso.get(0):"+ idPreaviso.get(0),new Exception());//NOPMD
		
		if (idPreaviso!=null && idPreaviso.size()>0 && idPreaviso.get(0)!=null)
		{
			idLoteNext=Integer.parseInt(idPreaviso.get(0).toString());
		}
		  
		W83aClsTrazas.trazaError(null, " &&&&&& idLoteNext:"+ idLoteNext,new Exception());//NOPMD
		
		
		strSql = new StringBuffer();
		strSql.append("SELECT ");
		strSql.append(W83aLotesPreavisosBD.codLote).append(",");
		strSql.append(W83aLotesPreavisosBD.dni).append(",");
		strSql.append(W83aUsuariosBD.nombre).append(",");
		strSql.append(W83aUsuariosBD.apellido1).append(",");
		strSql.append(W83aUsuariosBD.apellido2).append(",");
		strSql.append(W83aLotesPreavisosBD.territorio).append(",");
		strSql.append(W83aLotesPreavisosBD.correlativo).append(",");
		if("eu".equals(param.getIdioma())){
			strSql.append(W83aLotesPreavisosBD.descSindiEus).append(" AS ").append(W83aLotesPreavisosBD.descSindi).append(",");
		}else{
			strSql.append(W83aLotesPreavisosBD.descSindi).append(" AS ").append(W83aLotesPreavisosBD.descSindi).append(",");
		}		   
		strSql.append(W83aLotesPreavisosBD.ficheroIda).append(",");
		strSql.append(" TO_CHAR( ").append(W83aLotesPreavisosBD.fechaCreacion).append(",?) AS ").append(W83aLotesPreavisosBD.fechaCreacion).append(",");
		strSql.append(" TO_CHAR( ").append(W83aLotesPreavisosBD.fechaEntrada).append(",?) AS ").append(W83aLotesPreavisosBD.fechaEntrada);
		
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		strSql.append(" FROM ").append(W83aLotesPreavisosBD.lotesPreavisosTable);
		strSql.append(" , ").append(W83aLotesPreavisosBD.sindicatosTable);
		strSql.append(" , ").append(W83aLotesPreavisosBD.provinciasTable);
		strSql.append(" , ").append(W83aUsuariosBD.usuariosTable);
		strSql.append(" WHERE ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.codTerrit);
		strSql.append(" = ").append(W83aLotesPreavisosBD.provinciasTable).append(".").append(W83aLotesPreavisosBD.id);
		strSql.append(" AND ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.codSindi07);
		strSql.append(" = ").append(W83aLotesPreavisosBD.sindicatosTable).append(".").append(W83aLotesPreavisosBD.codSindi19);
		strSql.append(" AND ").append(W83aLotesPreavisosBD.lotesPreavisosTable).append(".").append(W83aLotesPreavisosBD.dni);
		strSql.append(" = ").append(W83aUsuariosBD.usuariosTable).append(".").append(W83aUsuariosBD.dni);
		strSql.append(" AND ").append(W83aLotesPreavisosBD.codLote).append(" = ").append(idLoteNext);
		

		W83aClsTrazas.trazaError(null, "SQL:"+ strSql.toString(),new Exception());//NOPMD
		W83aClsTrazas.trazaError(null, "LOTE: " + param.getCodLote(),new Exception());//NOPMD
		
		List listaLotes = W83aDataBase.executeQuery(strSql.toString(),params,W83aLotesPreavisosBean.class,param.getUsuarioBean(), null);
	
		W83aClsTrazas.trazaError(null, " &&&&&& listaLotes.size():"+ listaLotes.size(),new Exception());//NOPMD
		
		W83aLotesPreavisosBean param2 = (W83aLotesPreavisosBean)listaLotes.get(0);	
		param.setDescSindicato(param2.getDescSindicato());
		param.setFechaCreacion(param2.getFechaCreacion());
		param.setFechaEntrada(param2.getFechaEntrada());
		param.setTerritorio(param2.getTerritorio());
		
		W83aClsTrazas.trazaError(null, " &&&&&& ANTES DE INFO &&&&&&",new Exception());//NOPMD
		
		W83AInformacionProcedimiento info = new W83AInformacionProcedimiento(param.getSessionTokenXLNET(), W83AProperties.getProperty("w83a","catalogo.procedureId"));
		
		W83aNotificacionesBean informacionNotificacion= new W83aNotificacionesBean(usuario.getDniUsuario(), usuario.getNombreUsuario(), "", param.getNombreFichero(), idLoteNext+"", param.getSessionTokenXLNET(), territorio);
		
		//Aadimos los datos del emisor
		informacionNotificacion.setDniUsuarioEmisor(param2.getDniEmisorLote());
		informacionNotificacion.setSindicatoUsuarioEmisor(param2.getDescSindicato());
		informacionNotificacion.setNombreUsuarioEmisor(param2.getNombreEmisorLote());
		informacionNotificacion.setApellido1UsuarioEmisor(param2.getApellido1EmisorLote());
		informacionNotificacion.setApellido2UsuarioEmisor(param2.getApellido2EmisorLote());
		
		
		W83ANotificacionThread tareaNotificar=new W83ANotificacionThread((ArrayList)listaSindicatos,info,param.getSolicitudPreaviso(),informacionNotificacion,W83aClsConstantes.IDA, param.getNombreFichero(), param.getDocumentoImportadoOriginal(), param.getIdioma());
        tareaNotificar.start();
		
        
        param.setDescTerritorio(territorio);
        
		return param ;	
		
	}
	
	public W83aLotesPreavisosBean deshacerAltaLote(W83aLotesPreavisosBean param)
	throws Exception {
		
		
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
	//	StringBuffer strSqlCorrelativo = new StringBuffer(W83aClsConstantes.CUARENTA);
		
		W83aClsTrazas.trazaError(null, "DAO deshacerAltaLote", new Exception() );//NOPMD
		List params = new ArrayList();
		
		strSql.append("DELETE FROM  ");
		strSql.append(W83aLotesPreavisosBD.preavisosTable);
		strSql.append(" WHERE ");
		strSql.append(W83aLotesPreavisosBD.codLote8);
		strSql.append(" = ?");
		
		
		params.add(param.getCodLote());
		
		W83aDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		params.clear();
		strSql.append("DELETE FROM  ");
		strSql.append(W83aLotesPreavisosBD.lotesPreavisosTable);
		strSql.append(" WHERE ");
		strSql.append(W83aLotesPreavisosBD.codLote);
		strSql.append(" = ?");
		
		
		params.add(param.getCodLote());
		
		W83aDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		return param ;	
		
	}
	
}
